using System;
using System.Collections.Generic;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;

public class Merchant
{
    private List<Product> m_products;

    public Merchant()
    {
        ProductSales sales = new ProductSales();
        sales.Price = 12.99F;
        sales.Quantity = 250;
        m_products = new List<Product>();
        m_products.Add(new Product("Pen", 25, sales));
        m_products.Add(new Product("Pencil", 30, sales));
        m_products.Add(new Product("Notebook", 15, sales));
    }

    public List<Product> GetProducts()
    {
        return m_products;
    }
}

public class ProductSales
{
    public int Quantity;
    public float Price;

}
public class Product
{
    private string m_name;
    private int m_price;
    private ProductSales m_sales;

    public Product(string name, int price, ProductSales sales)
    {
        m_name = name;
        m_price = price;
        m_sales = sales;
    }

    public string Name
    {
        get
        {
            return m_name;
        }
    }

    public int Price
    {
        get
        {
            return m_price;
        }
    }
    public ProductSales Sales
    {
        get
        {
            return m_sales;
        }
    }
}

public class Demo : Form
{
    public Demo()
    {
        Merchant merchant = new Merchant();

        this.Text = "Report Control Demo";
        this.ClientSize = new System.Drawing.Size(950, 600);

        ReportViewer reportViewer = new ReportViewer();

        // Set Processing Mode

        reportViewer.ProcessingMode = ProcessingMode.Local;

        // Set RDL file

        reportViewer.LocalReport.ReportPath = "Report1.rdlc";

        // Supply data corresponding to each report data source.

        reportViewer.LocalReport.DataSources.Add(
            new ReportDataSource("Product", merchant.GetProducts()));

        // Add the reportviewer to the form

        reportViewer.Dock = DockStyle.Fill;
        this.Controls.Add(reportViewer);

        // Process and render the report

        reportViewer.RefreshReport();
    }

    [STAThread]
    public static int Main(string[] args)
    {
        Application.Run(new Demo());
        return 0;
    }
}
